#ifndef _Color_h__
#define _Color_h__

#include <buildspec.h>

#include <istream>
#include <ostream>

namespace GST
{
namespace Utils
{

/**0 .. 1 <=> off .. on*/
typedef float ColorCoding;
/**0 .. 1 <=> solid .. glas*/
typedef float TransparencyCoding;
/**0 .. 1 <=> glas .. solid (AlphaCoding == 1 - TransparencyCoding)*/
typedef float AlphaCoding;

//------------------------------------------------------------------------------

struct GST_API_EXPORT ColorRGB
{
	ColorCoding r;
	ColorCoding g;
	ColorCoding b;

	ColorRGB();

	ColorRGB(const ColorCoding &_r,
			 const ColorCoding &_g,
			 const ColorCoding &_b);

	///@name static generators
	//@{
	static ColorRGB Random();
	static ColorRGB Red();
	static ColorRGB Green();
	static ColorRGB Blue();
	static ColorRGB White();
	static ColorRGB Black();
	static ColorRGB GiGa_GreenLight();
	static ColorRGB GiGa_GreenMiddle();
	static ColorRGB GiGa_GreenDark();
	static ColorRGB FromHex(const std::string &hexColor);
	//@}
	std::string ToHexRGB() const;
	std::string ToHexRGBA() const;
	std::string ToHexARGB() const;

	bool operator==(const ColorRGB &other) const;
	// enable type for lexical_cast
	friend std::ostream &operator<<(std::ostream &os, const ColorRGB &c);
	friend std::istream &operator>>(std::istream &os, ColorRGB &c);
};

//------------------------------------------------------------------------------

struct GST_API_EXPORT ColorRGBA : public ColorRGB
{
	AlphaCoding a;

	ColorRGBA();

	ColorRGBA(const ColorCoding &_r,
			  const ColorCoding &_g,
			  const ColorCoding &_b,
			  AlphaCoding _a);

	ColorRGBA(const ColorRGB &other);

	ColorRGBA &operator=(const ColorRGB &other);
	bool operator==(const ColorRGBA &other) const;

	TransparencyCoding getTransparency() const;
	// enable type for lexical_cast
	friend std::ostream &operator<<(std::ostream &os, const ColorRGBA &c);
	friend std::istream &operator>>(std::istream &os, ColorRGBA &c);
};

} // namespace Utils
} // namespace GST

#endif // _Color_h__
